#!/usr/bin/env bash

set -e 

export VERSION="4.6.18"
export RELEASE="*"
echo "Shaka dist script for $VERSION"

# Copy the tarball
echo "cp ../../shaka-rel-v$VERSION-r$RELEASE.tar.gz ."
cp ../../shaka-rel-v$VERSION-r$RELEASE.tar.gz .

# Clone shaka repo
echo "git clone https://github.com/shaka-project/shaka-player.git"
git clone https://github.com/shaka-project/shaka-player.git
echo "cd shaka-player"
cd shaka-player

#Checkout branch from $VERSION tag
echo "git checkout -b amz_$VERSION v$VERSION"
git checkout -b amz_$VERSION v$VERSION

#Copy shaka-rel tarball
echo "cp ../shaka-rel-v$VERSION.tar.gz ."
cp ../shaka-rel-v$VERSION-r$RELEASE.tar.gz .

#Unpack tarball
echo "tar -xzf shaka-rel-v$VERSION.tar.gz"
tar -xzf shaka-rel-v$VERSION-r$RELEASE.tar.gz

#Apply patches
echo "git am shaka-rel/shaka-patch/*.patch -3"
git am shaka-rel/shaka-patch/*.patch -3

#Build shaka
echo "build/all.py"
build/all.py
