#!/usr/bin/env bash

set -e 

export VERSION="1.5.11"
export RELEASE="*"
echo "Hls dist script for $VERSION"

# Copy the tarball
echo "cp ../../hls-rel-v$VERSION-r$RELEASE.tar.gz ."
cp ../../hls-rel-v$VERSION-r$RELEASE.tar.gz .

# Clone hls repo
echo "git clone https://github.com/video-dev/hls.js.git"
git clone https://github.com/video-dev/hls.js.git
echo "cd hls.js"
cd hls.js

#Checkout branch from $VERSION tag
echo "git checkout -b amz_$VERSION v$VERSION"
git checkout -b amz_$VERSION v$VERSION

#Copy hls-rel tarball
echo "cp ../hls-rel-v$VERSION-r$RELEASE.tar.gz ."
cp ../hls-rel-v$VERSION-r$RELEASE.tar.gz .

#Unpack tarball
echo "tar -xzf hls-rel-v$VERSION-r$RELEASE.tar.gz"
tar -xzf hls-rel-v$VERSION-r$RELEASE.tar.gz

#Apply patches
echo "git apply hls-rel/hls-patch/*.patch -3"
git apply hls-rel/hls-patch/*.patch -3

#Install dependecies
echo "npm install"
npm install

#Build hls
echo "npm run build"
npm run build
