/*
 * Copyright 2022-2024 Amazon.com, Inc. or its affiliates. All rights reserved.
 *
 * AMAZON PROPRIETARY/CONFIDENTIAL
 *
 * You may not use this file except in compliance with the terms and
 * conditions set forth in the accompanying LICENSE.TXT file.
 *
 * THESE MATERIALS ARE PROVIDED ON AN "AS IS" BASIS. AMAZON SPECIFICALLY
 * DISCLAIMS, WITH RESPECT TO THESE MATERIALS, ALL WARRANTIES, EXPRESS,
 * IMPLIED, OR STATUTORY, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
 */

declare global {
  namespace globalThis {
    var gmedia: any;
    var document: Document;
  }
}

class Document {
  createElement = (name: string) => {
    console.log(`document.createElement ${name}`);
    return global.gmedia;
  };
  getElementsByTagName = (name: string) => {
    console.log(`document.getElementsByTagName ${name}`);
    return global.gmedia;
  };
  getElementsByClassName = (name: string) => {
    console.log(`document.getElementsByClassName ${name}`);
    return global.gmedia;
  };
  getElementById = (id: string) => {
    console.log(`document.getElementById ${id}`);
    return global.gmedia;
  };
  static install() {
    console.log('Installing Document polyfill');
    global.document = new Document();
    global.document.documentElement = global.gmedia;
  }
}

export default Document;
