#!/usr/bin/env bash

set -e 

export VERSION="5.0.0"
export RELEASE="*"
export COMMIT="ca4c7aa0227d001bb31801faa61a2d57c4e14da4"
echo "Dash dist script for $VERSION"

# Copy the tarball
echo "cp ../../dash-rel-v$VERSION-r$RELEASE.tar.gz ."
cp ../../dash-rel-v$VERSION-r$RELEASE.tar.gz .

# Clone dash repo
echo "git clone https://github.com/Dash-Industry-Forum/dash.js.git"
git clone https://github.com/Dash-Industry-Forum/dash.js.git
echo "cd dash.js"
cd dash.js

#Reset hard to $COMMIT  
echo "git reset --hard $COMMIT"
git reset --hard $COMMIT

#Checkout branch from current branch
echo "git checkout -b amz_$VERSION"
git checkout -b amz_$VERSION

#Copy dash-rel tarball
echo "cp ../dash-rel-v$VERSION-r$RELEASE.tar.gz ."
cp ../dash-rel-v$VERSION-r$RELEASE.tar.gz .

#Unpack tarball
echo "tar -xzf dash-rel-v$VERSION-r$RELEASE.tar.gz"
tar -xzf dash-rel-v$VERSION-r$RELEASE.tar.gz

#Apply patches
echo "git apply dash-rel/dash-patch/*.patch -3"
git apply dash-rel/dash-patch/*.patch -3

#Install dependecies
echo "npm install"
npm install

#Build dash
echo "npm run build"
npm run build
