/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.model;

import com.amazon.a.a.o.f;
import com.amazon.device.iap.internal.model.ReceiptBuilder;
import com.amazon.device.iap.model.ProductType;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public final class Receipt {
    private static final Date DATE_CANCELED = new Date(1L);
    private static final String RECEIPT_ID = "receiptId";
    private static final String SKU = "sku";
    private static final String PRODUCT_TYPE = "itemType";
    private static final String PURCHASE_DATE = "purchaseDate";
    private static final String CANCEL_DATE = "endDate";
    private static final String DEFERRED_DATE = "deferredDate";
    private static final String DEFERRED_SKU = "deferredSku";
    private static final String TERM_SKU = "termSku";
    private final String receiptId;
    private final String sku;
    private final ProductType productType;
    private final Date purchaseDate;
    private final Date cancelDate;
    private final String deferredSku;
    private final Date deferredDate;
    private final String termSku;

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.cancelDate == null ? 0 : this.cancelDate.hashCode());
        n2 = 31 * n2 + (this.productType == null ? 0 : this.productType.hashCode());
        n2 = 31 * n2 + (this.purchaseDate == null ? 0 : this.purchaseDate.hashCode());
        n2 = 31 * n2 + (this.deferredDate == null ? 0 : this.deferredDate.hashCode());
        n2 = 31 * n2 + (this.receiptId == null ? 0 : this.receiptId.hashCode());
        n2 = 31 * n2 + (this.sku == null ? 0 : this.sku.hashCode());
        n2 = 31 * n2 + (this.deferredSku == null ? 0 : this.deferredSku.hashCode());
        n2 = 31 * n2 + (this.termSku == null ? 0 : this.termSku.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Receipt receipt = (Receipt)object;
        if (this.cancelDate == null ? receipt.cancelDate != null : !this.cancelDate.equals(receipt.cancelDate)) {
            return false;
        }
        if (this.productType != receipt.productType) {
            return false;
        }
        if (this.purchaseDate == null ? receipt.purchaseDate != null : !this.purchaseDate.equals(receipt.purchaseDate)) {
            return false;
        }
        if (this.receiptId == null ? receipt.receiptId != null : !this.receiptId.equals(receipt.receiptId)) {
            return false;
        }
        if (this.sku == null ? receipt.sku != null : !this.sku.equals(receipt.sku)) {
            return false;
        }
        if (this.deferredSku == null ? receipt.deferredSku != null : !this.deferredSku.equals(receipt.deferredSku)) {
            return false;
        }
        if (this.deferredDate == null) {
            if (receipt.deferredDate != null) {
                return false;
            }
        } else {
            if (!this.deferredDate.equals(receipt.deferredDate)) {
                return false;
            }
            if (!this.termSku.equals(receipt.termSku)) {
                return false;
            }
        }
        return true;
    }

    public Receipt(ReceiptBuilder receiptBuilder) {
        f.a((Object)receiptBuilder.getSku(), SKU);
        f.a((Object)receiptBuilder.getProductType(), "productType");
        if (ProductType.SUBSCRIPTION == receiptBuilder.getProductType()) {
            f.a(receiptBuilder.getPurchaseDate(), PURCHASE_DATE);
        }
        this.receiptId = receiptBuilder.getReceiptId();
        this.sku = receiptBuilder.getSku();
        this.productType = receiptBuilder.getProductType();
        this.purchaseDate = receiptBuilder.getPurchaseDate();
        this.cancelDate = receiptBuilder.getCancelDate();
        this.deferredSku = receiptBuilder.getDeferredSku();
        this.deferredDate = receiptBuilder.getDeferredDate();
        this.termSku = receiptBuilder.getTermSku();
    }

    public String getReceiptId() {
        return this.receiptId;
    }

    public String getSku() {
        return this.sku;
    }

    public String getTermSku() {
        return this.termSku;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public Date getCancelDate() {
        return this.cancelDate;
    }

    public Date getDeferredDate() {
        return this.deferredDate;
    }

    public String getDeferredSku() {
        return this.deferredSku;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(RECEIPT_ID, (Object)this.receiptId);
            jSONObject.put(SKU, (Object)this.sku);
            jSONObject.put(PRODUCT_TYPE, (Object)this.productType);
            jSONObject.put(PURCHASE_DATE, (Object)this.purchaseDate);
            jSONObject.put(CANCEL_DATE, (Object)this.cancelDate);
            jSONObject.put(DEFERRED_SKU, (Object)this.deferredSku);
            jSONObject.put(DEFERRED_DATE, (Object)this.deferredDate);
            jSONObject.put(TERM_SKU, (Object)this.termSku);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public String toString() {
        String string = null;
        try {
            string = this.toJSON().toString(4);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string;
    }

    public boolean isCanceled() {
        return this.cancelDate != null;
    }

    public boolean isDeferred() {
        return this.deferredDate != null;
    }
}

