/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.billingclient.api;

import com.amazon.a.a.o.f;
import com.amazon.device.iap.billingclient.api.BillingClient;
import java.util.ArrayList;
import java.util.List;

public class QueryProductDetailsParams {
    private final List<Product> productList;

    private QueryProductDetailsParams(List<Product> list) {
        this.productList = list;
    }

    public List<Product> getProductList() {
        return new ArrayList<Product>(this.productList);
    }

    @BillingClient.ProductType
    public String getProductType() {
        return this.productList.get(0).getProductType();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<Product> productList;

        private Builder() {
        }

        public Builder setProductList(List<Product> list) {
            f.a(list, "Product list");
            f.a(list, "Product list");
            for (Product product : list) {
                if ("inapp".equals(product.getProductType())) continue;
                throw new IllegalArgumentException("Unsupported product type: " + product.getProductType() + " provided.");
            }
            this.productList = new ArrayList<Product>(list);
            return this;
        }

        public QueryProductDetailsParams build() {
            f.a(this.productList, "Product list");
            return new QueryProductDetailsParams(this.productList);
        }
    }

    public static class Product {
        private final String productId;
        @BillingClient.ProductType
        private final String productType;

        private Product(String string, @BillingClient.ProductType String string2) {
            this.productId = string;
            this.productType = string2;
        }

        public final String getProductId() {
            return this.productId;
        }

        @BillingClient.ProductType
        public final String getProductType() {
            return this.productType;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private String productId;
            @BillingClient.ProductType
            private String productType;

            private Builder() {
            }

            public Builder setProductId(String string) {
                this.productId = string;
                return this;
            }

            public Builder setProductType(@BillingClient.ProductType String string) {
                this.productType = string;
                return this;
            }

            public Product build() {
                f.a(this.productId, "Product id");
                f.a(this.productType, "Product type");
                return new Product(this.productId, this.productType);
            }
        }
    }
}

