/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.billingclient.api;

import com.amazon.a.a.o.e;
import com.amazon.a.a.o.f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Purchase {
    private final String purchaseJsonString;
    private final JSONObject purchaseJsonObject;

    public Purchase(String string) throws JSONException {
        f.a(string, "jsonPurchaseInfo");
        this.purchaseJsonString = string;
        this.purchaseJsonObject = new JSONObject(this.purchaseJsonString);
        f.a(this.getPurchaseToken(), "purchaseToken");
        f.a(this.getSkus(), "productId");
        this.validatePurchaseState();
        this.validatePurchaseTime();
    }

    @PurchaseState
    public int getPurchaseState() {
        return this.purchaseJsonObject.optInt("purchaseState", 1);
    }

    public long getPurchaseTime() {
        return this.purchaseJsonObject.optLong("purchaseTime");
    }

    public String getOriginalJson() {
        return this.purchaseJsonString;
    }

    public String getPurchaseToken() {
        return this.purchaseJsonObject.optString("purchaseToken");
    }

    public ArrayList<String> getSkus() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.purchaseJsonObject.has("productIds")) {
            JSONArray jSONArray = this.purchaseJsonObject.optJSONArray("productIds");
            if (jSONArray != null) {
                for (int k = 0; k < jSONArray.length(); ++k) {
                    String string2 = jSONArray.optString(k);
                    if (e.a(string2)) continue;
                    arrayList.add(string2);
                }
            }
        } else if (this.purchaseJsonObject.has("productId") && !e.a(string = this.purchaseJsonObject.optString("productId"))) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getProducts() {
        return this.getSkus();
    }

    public int getQuantity() {
        return this.purchaseJsonObject.optInt("quantity", 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Purchase)) {
            return false;
        }
        Purchase purchase = (Purchase)object;
        return this.purchaseJsonObject.equals(purchase.purchaseJsonObject);
    }

    public int hashCode() {
        return this.purchaseJsonObject.hashCode();
    }

    public String toString() {
        return "Purchase. Json: ".concat(this.purchaseJsonString);
    }

    private void validatePurchaseState() {
        List<Integer> list = Arrays.asList(0, 1, 2);
        if (!list.contains(this.getPurchaseState())) {
            throw new IllegalArgumentException("Invalid purchaseState provided: " + this.getPurchaseState());
        }
    }

    private void validatePurchaseTime() {
        if (this.getPurchaseTime() < 0L) {
            throw new IllegalArgumentException("purchaseTime can never be negative. Value provided: " + this.getPurchaseTime());
        }
    }

    public static @interface PurchaseState {
        public static final int UNSPECIFIED_STATE = 0;
        public static final int PURCHASED = 1;
        public static final int PENDING = 2;
    }
}

