/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.billingclient.api;

import com.amazon.a.a.o.f;
import com.amazon.device.iap.billingclient.api.BillingClient;
import org.json.JSONException;
import org.json.JSONObject;

public class ProductDetails {
    private final JSONObject productDetailsJsonObject;
    private final String productId;
    private final String type;
    private final String title;
    private final String name;
    private final String description;
    private final OneTimePurchaseOfferDetails oneTimePurchaseOfferDetails;

    public ProductDetails(String string) throws JSONException {
        this.productDetailsJsonObject = new JSONObject(string);
        this.productId = this.productDetailsJsonObject.optString("productId");
        f.a(this.getProductId(), "Product id");
        this.type = this.productDetailsJsonObject.optString("type");
        f.a(this.getProductType(), "Product type");
        if (!this.getProductType().equals("inapp")) {
            throw new IllegalArgumentException("Unsupported product type: " + this.getProductType() + " provided.");
        }
        this.title = this.productDetailsJsonObject.optString("title");
        this.name = this.productDetailsJsonObject.optString("name");
        this.description = this.productDetailsJsonObject.optString("description");
        JSONObject jSONObject = this.productDetailsJsonObject.optJSONObject("oneTimePurchaseOfferDetails");
        this.oneTimePurchaseOfferDetails = jSONObject != null ? new OneTimePurchaseOfferDetails(jSONObject) : null;
    }

    public String getProductId() {
        return this.productId;
    }

    @BillingClient.ProductType
    public String getProductType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public OneTimePurchaseOfferDetails getOneTimePurchaseOfferDetails() {
        return this.oneTimePurchaseOfferDetails;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProductDetails)) {
            return false;
        }
        ProductDetails productDetails = (ProductDetails)object;
        return this.productDetailsJsonObject.equals(productDetails.productDetailsJsonObject);
    }

    public final int hashCode() {
        return this.productDetailsJsonObject.hashCode();
    }

    public final String toString() {
        return "ProductDetails{jsonString='" + this.productDetailsJsonObject.toString() + "'}";
    }

    public static final class OneTimePurchaseOfferDetails {
        private final String formattedPrice;
        private final long priceAmountMicros;
        private final String priceCurrencyCode;

        public String getFormattedPrice() {
            return this.formattedPrice;
        }

        public long getPriceAmountMicros() {
            return this.priceAmountMicros;
        }

        public String getPriceCurrencyCode() {
            return this.priceCurrencyCode;
        }

        OneTimePurchaseOfferDetails(JSONObject jSONObject) {
            this.formattedPrice = jSONObject.optString("formattedPrice");
            this.priceAmountMicros = jSONObject.optLong("priceAmountMicros");
            this.priceCurrencyCode = jSONObject.optString("priceCurrencyCode");
        }
    }
}

