/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.billingclient.api;

import com.amazon.device.iap.billingclient.api.BillingClient;

public final class BillingResult {
    private int responseCode;
    private String debugMessage;

    @BillingClient.BillingResponseCode
    public int getResponseCode() {
        return this.responseCode;
    }

    public String getDebugMessage() {
        return this.debugMessage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "Response Code: " + this.responseCode + ", Debug Message: " + this.debugMessage;
    }

    public static final class Builder {
        private int responseCode;
        private String debugMessage = "";

        private Builder() {
        }

        public Builder setResponseCode(@BillingClient.BillingResponseCode int n) {
            this.responseCode = n;
            return this;
        }

        public Builder setDebugMessage(String string) {
            this.debugMessage = string;
            return this;
        }

        public BillingResult build() {
            BillingResult billingResult = new BillingResult();
            billingResult.responseCode = this.responseCode;
            billingResult.debugMessage = this.debugMessage;
            return billingResult;
        }
    }
}

