/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.billingclient.api;

import com.amazon.a.a.o.f;
import com.amazon.device.iap.billingclient.api.ProductDetails;
import com.amazon.device.iap.billingclient.api.SkuDetails;
import java.util.ArrayList;
import java.util.List;

public final class BillingFlowParams {
    private ArrayList<SkuDetails> skuDetailsList;
    private List<ProductDetailsParams> productDetailsParamsList;

    private BillingFlowParams() {
    }

    public final ArrayList<SkuDetails> getSkuDetailsList() {
        return this.skuDetailsList == null ? null : new ArrayList<SkuDetails>(this.skuDetailsList);
    }

    public final List<ProductDetailsParams> getProductDetailsParamsList() {
        return this.productDetailsParamsList == null ? null : new ArrayList<ProductDetailsParams>(this.productDetailsParamsList);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class ProductDetailsParams {
        private final ProductDetails productDetails;

        private ProductDetailsParams(ProductDetails productDetails) {
            this.productDetails = productDetails;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public final ProductDetails getProductDetails() {
            return this.productDetails;
        }

        public static class Builder {
            private ProductDetails productDetails;

            private Builder() {
            }

            public Builder setProductDetails(ProductDetails productDetails) {
                this.productDetails = productDetails;
                return this;
            }

            public ProductDetailsParams build() {
                f.a(this.productDetails, "Product details");
                return new ProductDetailsParams(this.productDetails);
            }
        }
    }

    public static final class Builder {
        private ArrayList<SkuDetails> skuDetailsList;
        private List<ProductDetailsParams> productDetailsParamsList;

        private Builder() {
        }

        public Builder setSkuDetails(SkuDetails skuDetails) {
            f.a(skuDetails, "SKU details");
            this.skuDetailsList = new ArrayList();
            this.skuDetailsList.add(skuDetails);
            return this;
        }

        public Builder setProductDetailsParamsList(List<ProductDetailsParams> list) {
            f.a(list, "Product details params list");
            if (list.size() > 1) {
                throw new IllegalArgumentException("At most 1 item(s) are allowed in a single purchase");
            }
            this.productDetailsParamsList = new ArrayList<ProductDetailsParams>(list);
            return this;
        }

        public BillingFlowParams build() {
            if (this.skuDetailsList == null && this.productDetailsParamsList == null) {
                throw new IllegalArgumentException("Either SKU details or product details params must be provided");
            }
            if (this.skuDetailsList != null && this.productDetailsParamsList != null) {
                throw new IllegalArgumentException("Only one of SKU details or product details params must be provided");
            }
            BillingFlowParams billingFlowParams = new BillingFlowParams();
            billingFlowParams.skuDetailsList = this.skuDetailsList;
            billingFlowParams.productDetailsParamsList = this.productDetailsParamsList;
            return billingFlowParams;
        }
    }
}

