/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.billingclient.api;

import android.app.Activity;
import android.content.Context;
import com.amazon.a.a.o.f;
import com.amazon.device.iap.billingclient.a.a;
import com.amazon.device.iap.billingclient.api.AcknowledgePurchaseParams;
import com.amazon.device.iap.billingclient.api.AcknowledgePurchaseResponseListener;
import com.amazon.device.iap.billingclient.api.BillingClientStateListener;
import com.amazon.device.iap.billingclient.api.BillingFlowParams;
import com.amazon.device.iap.billingclient.api.BillingResult;
import com.amazon.device.iap.billingclient.api.ConsumeParams;
import com.amazon.device.iap.billingclient.api.ConsumeResponseListener;
import com.amazon.device.iap.billingclient.api.ProductDetailsResponseListener;
import com.amazon.device.iap.billingclient.api.PurchasesResponseListener;
import com.amazon.device.iap.billingclient.api.PurchasesUpdatedListener;
import com.amazon.device.iap.billingclient.api.QueryProductDetailsParams;
import com.amazon.device.iap.billingclient.api.QueryPurchasesParams;
import com.amazon.device.iap.billingclient.api.SkuDetailsParams;
import com.amazon.device.iap.billingclient.api.SkuDetailsResponseListener;

public abstract class BillingClient {
    public abstract void querySkuDetailsAsync(SkuDetailsParams var1, SkuDetailsResponseListener var2);

    public abstract void queryProductDetailsAsync(QueryProductDetailsParams var1, ProductDetailsResponseListener var2);

    public abstract BillingResult launchBillingFlow(Activity var1, BillingFlowParams var2);

    public abstract void queryPurchasesAsync(@SkuType String var1, PurchasesResponseListener var2);

    public abstract void queryPurchasesAsync(QueryPurchasesParams var1, PurchasesResponseListener var2);

    public abstract void acknowledgePurchase(AcknowledgePurchaseParams var1, AcknowledgePurchaseResponseListener var2);

    public abstract void consumeAsync(ConsumeParams var1, ConsumeResponseListener var2);

    public abstract void startConnection(BillingClientStateListener var1);

    public abstract int getConnectionState();

    public abstract boolean isReady();

    public abstract void endConnection();

    public abstract BillingResult isFeatureSupported(@FeatureType String var1);

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public static final class Builder {
        private volatile PurchasesUpdatedListener purchasesUpdatedListener;
        private final Context context;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setListener(PurchasesUpdatedListener purchasesUpdatedListener) {
            this.purchasesUpdatedListener = purchasesUpdatedListener;
            return this;
        }

        public Builder enablePendingPurchases() {
            return this;
        }

        public BillingClient build() {
            f.a(this.context, "Context");
            f.a(this.purchasesUpdatedListener, "Listener for purchases updates");
            com.amazon.a.a.a(this.context);
            return a.a(this.purchasesUpdatedListener, this.context);
        }
    }

    public static @interface FeatureType {
        public static final String SUBSCRIPTIONS = "subscriptions";
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        public static final String PRICE_CHANGE_CONFIRMATION = "priceChangeConfirmation";
        public static final String IN_APP_MESSAGING = "bbb";
        public static final String PRODUCT_DETAILS = "fff";
    }

    public static @interface ConnectionState {
        public static final int CONNECTED = 2;
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CLOSED = 3;
    }

    public static @interface BillingResponseCode {
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int OK = 0;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int SERVICE_TIMEOUT = -3;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
    }

    public static @interface ProductType {
        public static final String INAPP = "inapp";
    }

    public static @interface SkuType {
        public static final String INAPP = "inapp";
    }
}

